/*
 * Decompiled with CFR 0.152.
 */
package com.tp_link.eap.monitor.hotspot.service.impl;

import com.tp_link.eap.domain.cloud.CloudUser;
import com.tp_link.eap.domain.global.OperationResult;
import com.tp_link.eap.domain.hotspot.Voucher;
import com.tp_link.eap.domain.portal.AuthInfo;
import com.tp_link.eap.domain.portal.Guest;
import com.tp_link.eap.domain.portal.StatCurrentGuest;
import com.tp_link.eap.domain.ui.Grid;
import com.tp_link.eap.domain.ui.QueryData;
import com.tp_link.eap.domain.ui.QueryFilter;
import com.tp_link.eap.domain.ui.QueryPage;
import com.tp_link.eap.domain.ui.QuerySort;
import com.tp_link.eap.monitor.hotspot.model.VoucherEntry;
import com.tp_link.eap.monitor.hotspot.repo.VoucherRepository;
import com.tp_link.eap.monitor.hotspot.service.VoucherServiceI;
import com.tp_link.eap.monitor.monitor.a.c;
import com.tp_link.eap.monitor.monitor.a.e;
import com.tp_link.eap.monitor.portal.service.b;
import com.tp_link.eap.monitor.portal.service.d;
import com.tp_link.eap.multicontrol.ControlType;
import com.tp_link.eap.multicontrol.OperationResponse;
import com.tp_link.eap.multicontrol.ResErrorCode;
import com.tp_link.eap.util.p.a;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import javax.validation.Validator;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.shiro.SecurityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="voucherService")
public class VoucherService
extends com.tp_link.eap.i.a.a<Voucher>
implements VoucherServiceI {
    private final Logger a = LoggerFactory.getLogger(this.getClass());
    private static final c b = com.tp_link.eap.monitor.monitor.a.e.b();
    private static Random c = new Random();
    @Autowired
    private VoucherRepository d;
    @Autowired
    private b e;
    @Autowired
    private d f;
    @Autowired
    private com.tp_link.eap.monitor.portal.service.a g;
    @Autowired
    private MongoTemplate h;
    @Autowired
    private Validator validator;
    @Autowired
    private com.tp_link.eap.monitor.cloud.clouduser.service.a i;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse handleAuthHotspot(AuthInfo info) {
        Object object;
        String string = info.getVoucherCode();
        if (!this.isVouCodeExistsInSite(string, com.tp_link.eap.d.b.e((String)info.getAp()))) {
            this.a.warn("Voucher code is not correct.");
            return new OperationResponse(ResErrorCode.bM);
        }
        Object object2 = object = com.tp_link.eap.b.b.a.c((String)string);
        synchronized (object2) {
            Voucher voucher = this.d.findByCode(string);
            long l2 = System.currentTimeMillis() / 1000L;
            if (voucher.getEndTime() != null && voucher.getEndTime() < l2) {
                this.a.debug("Voucher is expired.");
                return new OperationResponse(ResErrorCode.bN);
            }
            if (!voucher.getByteQuotaleft().booleanValue()) {
                this.a.debug("Voucher Traffic Limit exceeded");
                return new OperationResponse(ResErrorCode.bO);
            }
            if (voucher.getUsed() < voucher.getQuota()) {
                OperationResponse operationResponse;
                this.a.debug("handleAuthHotspot multi use.");
                if (voucher.getUsed() == 0) {
                    voucher.setStartTime(Long.valueOf(l2));
                    voucher.setEndTime(Long.valueOf(l2 + voucher.getDuration() * 60L));
                }
                voucher.setUsed(Integer.valueOf(voucher.getUsed() + 1));
                if (voucher.getQuota().equals(voucher.getUsed())) {
                    voucher.setValid(Boolean.valueOf(false));
                }
                if (!(operationResponse = this.g.addAuthInfo(info, voucher.getEndTime())).success()) {
                    this.a.debug("updateGuestStat fail.");
                    return operationResponse;
                }
                this.d.save(voucher);
                return com.tp_link.eap.util.e.bd;
            }
            if (voucher.getType() != 1) {
                this.a.debug("Voucher is expired.");
                return new OperationResponse(ResErrorCode.bN);
            }
            this.a.debug("handleAuthHotspot concurrent.");
            OperationResponse operationResponse = this.f.getCurrentGuestsByCode(voucher.getCode());
            if (operationResponse != null && operationResponse.size() >= voucher.getQuota()) {
                this.a.debug("Reach the limit of users: {}.", (Object)voucher.getQuota());
                return new OperationResponse(ResErrorCode.bP, "Reach the limit of users: " + voucher.getQuota() + ".", null);
            }
            List<Guest> list = this.e.getValidGuestsByVoucherCode(string);
            if (list == null || list.size() < voucher.getQuota()) {
                OperationResponse operationResponse2 = this.g.addAuthInfo(info, voucher.getEndTime());
                if (!operationResponse2.success()) {
                    this.a.debug("updateGuestStat fail.");
                    return operationResponse2;
                }
                return com.tp_link.eap.util.e.bd;
            }
            Guest guest = this.a(list, (List<StatCurrentGuest>)operationResponse);
            this.a.debug("get useless guest: " + guest);
            if (guest == null) {
                this.a.debug("VoucherService handleAuthHotspot no guest can be kictout.");
                return new OperationResponse(ResErrorCode.bP, "Reach the limit of users: " + voucher.getQuota() + ".", null);
            }
            OperationResponse operationResponse3 = this.g.kickoutHotspotGuest(guest);
            this.a.debug("kick out hotspot guest: " + guest);
            if (!operationResponse3.success()) {
                return operationResponse3;
            }
            operationResponse = this.g.addAuthInfo(info, voucher.getEndTime());
            if (!operationResponse.success()) {
                this.a.debug("updateGuestStat fail.");
                return operationResponse;
            }
            return com.tp_link.eap.util.e.bd;
        }
    }

    @Override
    public OperationResult clearVouchers(Long expiredSeconds) {
        long l2 = System.currentTimeMillis() / 1000L;
        Query query = new Query();
        query.addCriteria(Criteria.where((String)"used").gt((Object)0));
        query.addCriteria(Criteria.where((String)"endTime").lte((Object)(l2 - expiredSeconds)));
        List list = this.h.find(query, Voucher.class);
        this.a.debug("clear vouchers size:" + list.size());
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new OperationResult(true, "No vouchers need to be clear.");
        }
        for (Voucher voucher : list) {
            com.tp_link.eap.b.b.a.d((String)voucher.getCode());
            this.d.delete(voucher);
        }
        return new OperationResult(true, String.format("Clear %s vouchers totally.", list.size()));
    }

    @Override
    public OperationResult delUnusedVouByCreatedTime(String time) {
        String string = com.tp_link.eap.d.b.a();
        if (null == string) {
            return com.tp_link.eap.util.e.be;
        }
        if (com.tp_link.eap.util.a.e.a((String)time)) {
            return com.tp_link.eap.util.e.aX;
        }
        Query query = new Query();
        query.addCriteria(Criteria.where((String)"createdTime").is((Object)Long.parseLong(time)));
        query.addCriteria(Criteria.where((String)"site").is((Object)string));
        query.addCriteria(Criteria.where((String)"used").is((Object)0));
        this.h.remove(query, Voucher.class);
        return new OperationResult(true, "Delete batch vouchers successfully.");
    }

    private Guest a(List<Guest> list, List<StatCurrentGuest> list2) {
        if (list == null) {
            return null;
        }
        if (list2 == null) {
            return list.get(0);
        }
        for (Guest guest : list) {
            int n2 = 0;
            for (n2 = 0; n2 < list2.size() && !guest.getId().equals(list2.get(n2).getGuestid()); ++n2) {
            }
            if (n2 != list2.size()) continue;
            return guest;
        }
        return null;
    }

    @Override
    public List<Voucher> getAll() {
        List list = com.tp_link.eap.util.a.a.a((Iterable)this.d.findAll());
        if (null == list || list.isEmpty()) {
            return null;
        }
        return list;
    }

    private String a(int n2) {
        int n3 = 10;
        n2 = n2 == 0 ? 10 : n2;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder.append(c.nextInt(10));
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse addVouchers(Voucher voucher, int num) {
        if (null == voucher || num <= 0) {
            return com.tp_link.eap.util.e.aZ;
        }
        if (this.d.count() + (long)num > 50000L) {
            return new OperationResponse(ResErrorCode.ee);
        }
        ArrayList<Voucher> arrayList = new ArrayList<Voucher>(num);
        HashSet<String> hashSet = new HashSet<String>(num);
        String string = com.tp_link.eap.d.b.a();
        if (null == string) {
            return com.tp_link.eap.util.e.aZ;
        }
        VoucherService voucherService = this;
        synchronized (voucherService) {
            long l2 = System.currentTimeMillis() / 1000L;
            Query query = new Query();
            query.addCriteria(Criteria.where((String)"createdTime").is((Object)l2));
            while (this.h.exists(query, Voucher.class)) {
                query = new Query();
                query.addCriteria(Criteria.where((String)"createdTime").is((Object)(++l2)));
            }
            for (int i2 = 0; i2 < num; ++i2) {
                String string2;
                Voucher voucher2 = new Voucher();
                voucher2.setDuration(voucher.getDuration());
                voucher2.setNote(voucher.getNote());
                voucher2.setType(voucher.getType());
                voucher2.setQuota(voucher.getQuota());
                voucher2.setUsed(Integer.valueOf(0));
                voucher2.setEndTime(Long.valueOf(9999999999L));
                voucher2.setAdminName(voucher.getAdminName());
                voucher2.setSite(string);
                voucher2.setDownLimit(voucher.getDownLimit());
                voucher2.setUpLimit(voucher.getUpLimit());
                voucher2.setByteQuota(voucher.getByteQuota());
                voucher2.setDownLimitEnable(voucher.getDownLimitEnable());
                voucher2.setUpLimitEnable(voucher.getUpLimitEnable());
                voucher2.setByteQuotaEnable(voucher.getByteQuotaEnable());
                voucher2.setByteQuotaleft(voucher.getByteQuotaleft());
                while (this.isVouCodeExists(string2 = this.a(voucher.getCodeLength())) || hashSet.contains(string2)) {
                }
                hashSet.add(string2);
                voucher2.setCode(string2);
                voucher2.setCodeAlias(string2);
                voucher2.setCreatedTime(Long.valueOf(l2));
                arrayList.add(voucher2);
            }
            this.d.save(arrayList);
        }
        return new OperationResponse(ResErrorCode.a, "Add vouchers successfully.", null);
    }

    private String a(String string) {
        int n2 = 5;
        if (string.length() <= 5) {
            return string;
        }
        int n3 = (string.length() + 1) / 2;
        return string.substring(0, n3) + "-" + string.substring(n3);
    }

    @Override
    public OperationResponse delVouByCode(String code) {
        Voucher voucher = this.d.findByCode(code);
        if (null == voucher) {
            return new OperationResponse(ResErrorCode.ee, String.format("Voucher %s not exists.", code), null);
        }
        this.d.delete(voucher);
        return new OperationResponse(ResErrorCode.a, String.format("Voucher %s was deleted.", code), null);
    }

    @Override
    public OperationResult delVoucherById(String voucherId) {
        Voucher voucher = (Voucher)this.d.findOne((Serializable)((Object)voucherId));
        if (null == voucher) {
            return new OperationResult(false, String.format("Voucher %s not exists.", voucherId));
        }
        this.d.delete((Serializable)((Object)voucherId));
        return new OperationResult(true, String.format("Voucher %s was deleted.", voucherId));
    }

    @Override
    public OperationResult delAllVouchersInSite() {
        String string = com.tp_link.eap.d.b.a();
        Query query = new Query();
        query.addCriteria(Criteria.where((String)"site").is((Object)string));
        this.h.remove(query, Voucher.class);
        return new OperationResult(true, "Vouchers were deleted.");
    }

    @Override
    public List<Voucher> getAllVouchersInSite() {
        String string = com.tp_link.eap.d.b.a();
        Query query = new Query();
        query.addCriteria(Criteria.where((String)"site").is((Object)string));
        return this.h.find(query, Voucher.class);
    }

    @Override
    public List<Voucher> getPrintVouchers(String time) {
        String string = com.tp_link.eap.d.b.a();
        if (null == string) {
            return null;
        }
        Query query = new Query();
        if (!com.tp_link.eap.util.a.e.a((String)time)) {
            query.addCriteria(Criteria.where((String)"createdTime").is((Object)Long.parseLong(time)));
        }
        query.addCriteria(Criteria.where((String)"site").is((Object)string));
        query.addCriteria(Criteria.where((String)"used").is((Object)0));
        query.limit(10000);
        return this.h.find(query, Voucher.class);
    }

    @Override
    public boolean isVouCodeExists(String code) {
        Voucher voucher = this.d.findByCode(code);
        return voucher != null;
    }

    @Override
    public boolean isVouCodeExistsInSite(String code, String site) {
        if (com.tp_link.eap.util.a.e.a((String)code) || com.tp_link.eap.util.a.e.a((String)site)) {
            return false;
        }
        Query query = new Query();
        query.addCriteria(Criteria.where((String)"code").is((Object)code));
        query.addCriteria(Criteria.where((String)"site").is((Object)site));
        return this.h.exists(query, Voucher.class);
    }

    public List<Voucher> getList(QueryPage queryPage) {
        List<Voucher> list = this.getList(queryPage, null, null, null);
        if (null == list || list.isEmpty()) {
            return null;
        }
        return list;
    }

    public List<Voucher> getList(QueryPage queryPage, QuerySort querySort) {
        List<Voucher> list = this.getList(queryPage, querySort, null, null);
        if (null == list || list.isEmpty()) {
            return null;
        }
        return list;
    }

    public List<Voucher> getList(QueryPage queryPage, List<QueryFilter> filters, List<QueryFilter> searchFilters) {
        List<Voucher> list = this.getList(queryPage, null, filters, searchFilters);
        if (null == list || list.isEmpty()) {
            return null;
        }
        return list;
    }

    public List<Voucher> getList(QueryPage queryPage, QuerySort querySort, List<QueryFilter> filters, List<QueryFilter> searchFilters) {
        List<Voucher> list = this.d.getByFilters(queryPage, querySort, filters, searchFilters);
        if (null == list || list.isEmpty()) {
            return null;
        }
        return list;
    }

    public long count(List<QueryFilter> filters, List<QueryFilter> searchFilters) {
        return this.d.getByFilters(null, null, filters, searchFilters).size();
    }

    @Override
    public Voucher getVoucherByCode(String code) {
        if (code == null) {
            return null;
        }
        return this.d.findByCode(code);
    }

    @Override
    public Voucher getVoucherById(String id) {
        if (id == null) {
            return null;
        }
        return (Voucher)this.d.findOne((Serializable)((Object)id));
    }

    @Override
    public boolean updateVoucher(Voucher voucher) {
        if (!this.isVouCodeExistsInSite(voucher.getCode(), voucher.getSite()) && this.d.count() >= 50000L) {
            return false;
        }
        this.d.save(voucher);
        return true;
    }

    @Override
    public long count() {
        return this.d.count();
    }

    @Override
    public void deleteAll() {
        this.d.deleteAll();
    }

    @Override
    public OperationResponse getGridVouchers(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            this.a.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        QueryData queryData = (QueryData)JSONObject.toBean((JSONObject)jSONObject, QueryData.class);
        String string = queryData.getSortName();
        if (com.tp_link.eap.util.a.e.a((String)string)) {
            queryData.setSortName("_id");
            queryData.setSortOrder("desc");
        } else {
            queryData.setSortName(string + ",_id");
        }
        Grid grid = new Grid(queryData);
        grid.initSearch(queryData.getSearchKey(), new String[]{"codeAlias", "note"});
        ArrayList<QueryFilter> arrayList = new ArrayList<QueryFilter>();
        QueryFilter queryFilter = new QueryFilter("endTime", (Object)(System.currentTimeMillis() / 1000L), QueryFilter.FilterType.gt);
        arrayList.add(queryFilter);
        grid.setFilters(arrayList);
        long l2 = this.count(grid);
        grid.setTotalRows(l2);
        List list = this.getList(grid);
        if (null == list || list.isEmpty()) {
            return new OperationResponse(ResErrorCode.a, (Object)grid);
        }
        queryData.setSortName(string);
        grid.setData(list);
        return new OperationResponse(ResErrorCode.a, (Object)grid);
    }

    @Override
    public OperationResponse addVoucher(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            this.a.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        VoucherEntry voucherEntry = (VoucherEntry)JSONObject.toBean((JSONObject)jSONObject, VoucherEntry.class);
        OperationResponse operationResponse = com.tp_link.eap.util.p.a.a((Validator)this.validator, (Object)voucherEntry);
        if (!operationResponse.success()) {
            return operationResponse;
        }
        if (null == voucherEntry) {
            return com.tp_link.eap.util.e.aZ;
        }
        if (voucherEntry.getAmount() > 10000 || voucherEntry.getAmount() <= 0) {
            return com.tp_link.eap.util.e.aZ;
        }
        Voucher voucher = new Voucher();
        voucher.setNote(voucherEntry.getNote());
        voucher.setType(voucherEntry.getType());
        voucher.setQuota(voucherEntry.getQuota());
        voucher.setDuration(voucherEntry.getDuration());
        String string = null;
        if (controlType.equals((Object)ControlType.c) || controlType.equals((Object)ControlType.a)) {
            voucher.setAdminName((String)SecurityUtils.getSubject().getPrincipal());
            string = SecurityUtils.getSubject().hasRole("administrator") ? "Admin" : "Operator";
        } else {
            String string2 = com.tp_link.eap.monitor.cloud.e.a.a(reqObj);
            if (com.tp_link.eap.util.a.e.a((String)string2)) {
                this.a.warn("Failed to find accountId for cloud addVoucher");
                return com.tp_link.eap.util.e.aY;
            }
            CloudUser cloudUser = this.i.getCloudUserByAccountId(string2);
            if (cloudUser == null) {
                return new OperationResponse(ResErrorCode.ct);
            }
            voucher.setAdminName(cloudUser.getAccountName());
            string = cloudUser.getRole().getName().equals("administrator") ? "Admin" : "Operator";
        }
        voucher.setUpLimitEnable(voucherEntry.getUpLimitEnable());
        voucher.setDownLimitEnable(voucherEntry.getDownLimitEnable());
        voucher.setByteQuotaEnable(voucherEntry.getByteQuotaEnable());
        voucher.setUpLimit(voucherEntry.getUpLimitRate());
        voucher.setDownLimit(voucherEntry.getDownLimitRate());
        voucher.setByteQuota(voucherEntry.getByteQuota());
        voucher.setCodeLength(voucherEntry.getCodeLength());
        voucher.setByteQuotaleft(Boolean.TRUE);
        operationResponse = this.addVouchers(voucher, voucherEntry.getAmount());
        if (operationResponse.success()) {
            b.a("HS", "VoucherCreated", String.format("%s[%s] created %d %s voucher(s)", string, voucher.getAdminName(), voucherEntry.getAmount(), voucher.getType() == 0 ? "single-use" : "multi-use"));
        }
        return operationResponse;
    }

    @Override
    public OperationResponse deleteVoucher(ControlType controlType, JSONObject reqObj) {
        String string;
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            this.a.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        String string2 = null;
        String string3 = null;
        if (controlType.equals((Object)ControlType.c) || controlType.equals((Object)ControlType.a)) {
            string2 = (String)SecurityUtils.getSubject().getPrincipal();
            string3 = SecurityUtils.getSubject().hasRole("administrator") ? "Admin" : "Operator";
        } else {
            string = com.tp_link.eap.monitor.cloud.e.a.a(reqObj);
            if (com.tp_link.eap.util.a.e.a((String)string)) {
                this.a.warn("Failed to find accountId for cloud deleteVoucher");
                return com.tp_link.eap.util.e.aY;
            }
            CloudUser cloudUser = this.i.getCloudUserByAccountId(string);
            if (cloudUser == null) {
                return new OperationResponse(ResErrorCode.ct);
            }
            string2 = cloudUser.getAccountName();
            string3 = cloudUser.getRole().getName().equals("administrator") ? "Admin" : "Operator";
        }
        string = jSONObject.getJSONArray("selectedVouchers");
        for (int i2 = 0; i2 < string.size(); ++i2) {
            String string4 = string.getString(i2);
            OperationResponse operationResponse = this.delVouByCode(string4);
            if (!operationResponse.success()) {
                return operationResponse;
            }
            b.b("HS", "VoucherDeleted", String.format("Voucher[%s] was deleted by %s[%s]", string4, string3, string2));
        }
        return new OperationResponse(ResErrorCode.a, "Voucher was deleted.", null);
    }

    @Override
    public OperationResponse printVoucher(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            this.a.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        JSONArray jSONArray = jSONObject.optJSONArray("times");
        if (jSONArray == null) {
            return com.tp_link.eap.util.e.bd;
        }
        Grid grid = new Grid();
        List<Voucher> list = this.getPrintVouchers(jSONArray.optString(0, null));
        grid.setData(list);
        return new OperationResponse(ResErrorCode.a, (Object)grid);
    }

    @Override
    public OperationResponse printVoucherByCode(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            this.a.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.optString("voucherCode");
        Grid grid = new Grid();
        ArrayList<Voucher> arrayList = new ArrayList<Voucher>(Arrays.asList(this.getVoucherByCode(string)));
        grid.setData(arrayList);
        return new OperationResponse(ResErrorCode.a, (Object)grid);
    }

    @Override
    public OperationResponse printVoucherById(ControlType controlType, JSONObject reqObj) {
        int n2;
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            this.a.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.optString("type", null);
        JSONArray jSONArray = jSONObject.optJSONArray("id");
        List<Object> list = new ArrayList();
        if (string.equalsIgnoreCase("all")) {
            list = this.getAllVouchersInSite();
        } else if (string.equalsIgnoreCase("exclude")) {
            list = this.getAllVouchersInSite();
            block0: for (n2 = 0; n2 < jSONArray.size(); ++n2) {
                for (Voucher voucher : list) {
                    if (!voucher.getId().equals(jSONArray.optString(n2))) continue;
                    list.remove(voucher);
                    continue block0;
                }
            }
        } else if (string.equalsIgnoreCase("include")) {
            for (n2 = 0; n2 < jSONArray.size(); ++n2) {
                list.add(this.getVoucherById(jSONArray.optString(n2)));
            }
        }
        Grid grid = new Grid();
        grid.setData(list);
        return new OperationResponse(ResErrorCode.a, (Object)grid);
    }

    @Override
    public OperationResponse deleteVoucherById(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            this.a.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.optString("type");
        JSONArray jSONArray = jSONObject.optJSONArray("id");
        if (jSONArray == null) {
            return com.tp_link.eap.util.e.aZ;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < jSONArray.size(); ++i2) {
            arrayList.add(jSONArray.optString(i2, null));
        }
        if (string.equalsIgnoreCase("all")) {
            this.delAllVouchersInSite();
        } else if (string.equalsIgnoreCase("exclude")) {
            ArrayList<String> arrayList2 = arrayList;
            List<Voucher> list = this.getAllVouchersInSite();
            for (Voucher voucher : list) {
                String string2 = voucher.getId();
                if (arrayList2.contains(string2)) continue;
                this.delVoucherById(string2);
            }
        } else if (string.equalsIgnoreCase("include")) {
            for (String string3 : arrayList) {
                this.delVoucherById(string3);
            }
        } else {
            return com.tp_link.eap.util.e.aZ;
        }
        return com.tp_link.eap.util.e.bd;
    }

    @Override
    public OperationResponse checkVoucherOverLimit(ControlType controlType, JSONObject reqObj) {
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        hashMap.put("data", this.count() >= 50000L);
        return new OperationResponse(ResErrorCode.a, hashMap);
    }
}

